import { http } from '@inside-library/helpers/Http'

export const fetchProject = async ({ $route }) => {
  try {
    const { data } = await http.get('content/projects', {
      fields: [
        'uuid',
        'title',
        'slug',
        'published_at',
        'admin',
        'content_type',
        'banner',
        'short_summary',
        'content',
        'start_date',
        'end_date',
        {
          users: ['uuid', 'lastname', 'firstname', 'image', 'function', 'phone']
        },
        {
          projects_categories: ['uuid', 'title']
        },
        {
          project_documents: ['uuid', 'title', 'file']
        },
        {
          statuses: ['uuid', 'title', 'color']
        }
      ],
      filters: { 'slug:eq': $route.params.slug, 'status:eq': 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
