import SpacesListingPage from '../pages/spaces/SpacesListingPage'
import SpacesPage from '../pages/spaces/SpacesPage'
import { fetchSpacesListing, fetchSpacesPage } from '../components/spaces'

import ProjectPage from '../pages/projects/ProjectPage'
import { fetchProject } from '../components/projects'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: { filtersInput: 'selectbox' }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/directory/DirectoryPage')
  },
  {
    name: 'SpacesListingPage',
    path: '/espaces-metiers',
    component: withFetch(SpacesListingPage)(fetchSpacesListing)
  },
  {
    name: 'SpacesPage',
    path: '/espaces-metiers/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'ProjectsListingPage',
    path: '/projets',
    component: () => import('../pages/projects/ProjectsListingPage')
  },
  {
    name: 'ProjectPage',
    path: '/projets/:slug',
    meta: { content: 'projects' },
    component: withFetch(ProjectPage, { size: 'xxl', watch: true })(
      fetchProject
    )
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
