import { http } from '@inside-library/helpers/Http'

import get from 'lodash/get'

export default {
  localisations: {
    add: () => ({ path: '/' })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  pagesCategories: {
    fields: ['uuid', { spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.slug[0] },
      query: { tab: data.uuid }
    }),
    delete: () => ({
      routeAs: 'add'
    })
  },
  spacesPages: {
    fields: [{ pages_categories: ['uuid', { spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      },
      query: { tab: data.pages_categories.uuid }
    }),
    delete: () => ({
      routeAs: 'add'
    }),
    globalSearch: async ({ data }) => {
      const { data: tabsPage } = await http.get('content/spaces_pages', {
        fields: [{ pages_categories: ['uuid', { spaces: ['slug'] }] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacesPage',
          params: {
            slug: tabsPage?.[0].pages_categories?.spaces?.slug?.[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  statuses: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  projectsCategories: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  projects: {
    add: ({ data }) => ({
      name: 'ProjectPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'ProjectListingPage'
    })
  },
  projectFolders: {
    add: async ({ fields }) => {
      if (fields.projects) {
        try {
          const { data: project } = await http.get('content/projects', {
            fields: ['uuid', 'title', 'slug'],
            filters: { 'uuid:eq': fields.projects[0] }
          })

          const slug = get(project, [0, 'slug', 0])

          return {
            name: 'ProjectPage',
            params: { slug }
          }
        } catch (err) {
          return {
            name: 'ProjectsListingPage'
          }
        }
      } else if (fields.project_folders) {
        try {
          const { data: project } = await http.get('content/project_folders', {
            fields: [
              'uuid',
              'title',
              {
                projects: ['uuid', 'title', 'slug']
              }
            ],
            filters: { 'uuid:eq': fields.project_folders }
          })

          const slug = get(project, [0, 'projects', 'data', 0, 'slug', 0])

          return {
            name: 'ProjectPage',
            params: { slug }
          }
        } catch (err) {
          return {
            name: 'ProjectsListingPage'
          }
        }
      } else {
        return {
          name: 'ProjectsListingPage'
        }
      }
    },
    delete: () => ({
      name: 'ProjectListingPage'
    })
  },
  projectDocuments: {
    add: async ({ fields }) => {
      if (fields.project_folders) {
        try {
          const { data: project } = await http.get('content/project_folders', {
            fields: [
              'uuid',
              'title',
              {
                projects: ['uuid', 'title', 'slug']
              }
            ],
            filters: { 'uuid:eq': fields.project_folders }
          })

          const slug = get(project, [0, 'projects', 'data', 0, 'slug', 0])

          return {
            name: 'ProjectPage',
            params: { slug }
          }
        } catch (err) {
          return {
            name: 'ProjectsListingPage'
          }
        }
      } else {
        return {
          name: 'ProjectsListingPage'
        }
      }
    },
    delete: () => ({
      name: 'ProjectListingPage'
    })
  }
}
