<?php

use Inside\Content\Models\Contents\Comments;
use Inside\Content\Models\Contents\News;
use Inside\Content\Models\Contents\Users;
use Inside\Reaction\Models\Reaction;

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => 'newsletter_',
    ],
    'logo' => [
        'showLogo' => true,
        'logoUrl' => 'vendor/maecia/irts-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 170,
    ],
    'banner' => [
        'backgroundImageUrl' => 'vendor/maecia/irts-back/resources/assets/img/newsletter/banner.jpg',
        'backgroundColor' => '#FFFFF'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_intro',
    ],
    'sections' => [
        'news' => [
            'types' => ['news'],
            'sorts' => ['published_at:desc'],
            'defaultImageUrl' => 'vendor/maecia/irts-back/resources/assets/newsletter/img/news-default.png',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#9478FF',
            ],
        ],
        'new_members' => [
            'types' => ['movements'],
            'sorts' => ['published_at:desc'],
            'link' => [
                'sectionLinkUrl' => 'mouvements',
                'sectionTextColor' => '#9478FF',
                'sectionLinkStrKey' => 'newsletter.see_all_new_members'
            ]
        ],
        'events' => [
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#9478FF',
            'link' => [
                'sectionLinkUrl' => 'evenements',
                'sectionTextColor' => '#9478FF',
            ],
        ],
        'activities' => [
            'sectionTitleStrKey' => 'Activités en chiffres',
            'link' => null, // Pas de links
            'orientation' => 'horizontal',
            'defaultBackgroundColor' => '#FFFFF',
            'defaultValueColor' => '#2C3E50',
            'items' => [
                'comments' => [
                    'callback' => fn () => Comments::count(),
                    'backgroundImageUrl' => 'vendor/maecia/irts-back/resources/assets/img/newsletter/comments.png',
                    'titleStrKey' => 'newsletter.comments_statistic',
                ],
                'likes' => [
                    'callback' => fn () => Reaction::where('type', 'like')->count(),
                    'backgroundImageUrl' => 'vendor/maecia/irts-back/resources/assets/img/newsletter/likes.png',
                    'titleStrKey' => 'newsletter.likes_statistic',
                ],
                'users' => [
                    'callback' => fn () => Users::where('status', true)->count(),
                    'backgroundImageUrl' => 'vendor/maecia/irts-back/resources/assets/img/newsletter/users.png',
                    'titleStrKey' => 'newsletter.users_statistic',
                ],
                'news' => [
                    'callback' => fn () => News::where('status', true)->count(),
                    'backgroundImageUrl' => 'vendor/maecia/irts-back/resources/assets/img/newsletter/news.png',
                    'titleStrKey' => 'newsletter.contents_statistic',
                ],
            ],
        ],
    ],
    'socials' => [
        'backgroundColor' => '#9478FF',
        'links' => [
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/irt-saintex/',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/irtSaintEx',
            ],
            'youtube' => [
                'url' => 'https://www.youtube.com/user/IRTsaintex',
            ],
        ],
    ],
];
