<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class SwitchAboutMeFieldTypeInUsers extends Migration
{
    public function up(): void
    {
        $users = Users::select('uuid', 'about_me')->whereNotNull('about_me')->get();
        $bridgeContentType = new BridgeContentType();
        $bridge = new BridgeContent();

        if (Schema::hasField('users', 'about_me')) {
            $bridgeContentType->contentTypeDeleteField('user', 'user', 'about_me');
        }

        $bridgeContentType->contentTypeCreateOrUpdateField(
            'users',
            'about_me',
            [
                'name' => 'about_me',
                'searchable' => false,
                'translatable' => false,
                'editable' => true,
                'required' => false,
                'weight' => 11,
                'title' => [
                    'fr' => 'A propos de moi',
                ],
                'description' => [
                    'fr' => 'à propos de moi',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 11,
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );

        $users->each(fn ($user) => $bridge->contentUpdate('users', [
            'uuid' => $user->uuid,
            'about_me' => $user->about_me
        ]));
    }
}
