<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Competences;
use Inside\Content\Models\Contents\Services;
use Inside\Host\Bridge\BridgeContent;

class PurgeServicesAndCompetences extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        Services::all()->each(fn (Services $service) => $bridge->contentDelete('services', $service->uuid));
        Competences::all()->each(fn (Competences $competence) => $bridge->contentDelete('competences', $competence->uuid));
    }
}
