<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddUsersRegistrationNumberField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            'users',
            'registration_number',
            [
                'name' => 'registration_number',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Matricule',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
        );
        $this->finishUp();
    }
}
