<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        // spaces
        $this->bridge->contentTypeDeleteField('node', 'spaces', 'users');
        $this->bridge->contentTypeDeleteField('node', 'spaces', 'tools');
        $this->bridge->contentTypeDeleteField('node', 'spaces', 'documents');
        $this->bridge->contentTypeDeleteField('node', 'spaces', 'news_categories');

        $this->bridge->contentTypeCreateOrUpdateField('spaces', 'icon', [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Icon',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);

        $this->bridge->contentTypeCreateOrUpdateField('spaces', 'image', [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ]);

        // spaces_categories & spaces_pages
        $weight = [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Ordre d\'affichage',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ];

        $this->bridge->contentTypeCreateOrUpdateField('pages_categories', 'weight', $weight);
        $this->bridge->contentTypeCreateOrUpdateField('spaces_pages', 'weight', $weight);

        // projects
        $this->bridge->contentTypeUpdate('projects', [
            'translatable' => false,
            'searchable' => true,
            'global_searchable' => true,
            'aliasable' => true,
            'permissible' => true,
            'categorizable' => false,
            'listing_type' => 'content',
        ]);

        $this->finishUp();
    }
}
