<?php

use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

function get_entity_reference(?string $title, BridgeContent $bridge, string $contentType): ?string
{
    if (empty($title)) {
        return null;
    }

    $entity = call_user_func(type_to_class($contentType).'::query')
        ->where('title', $title)->first();
    if ($entity) {
        $uuid = $entity->uuid;
    } else {
        $uuid = $bridge->contentInsert($contentType, [
            'type' => 'node',
            'bundle' => $contentType,
            'title' => $title,
        ]);
    }

    return $uuid;
}

return [
    'files' => [
        'irts' => [
            'path' => env('IRTS_USERS_PATH', __DIR__.'/../../../../imports/import.csv'),
            'separator' => ';',
            'fields' => [
                'upn' => fn ($record) => trim($record['upn']),
                'name' => fn ($record) => trim($record['email salarié']),
                'mail' => fn ($record) => trim($record['email salarié']),
                'firstname' => fn ($record) => ucwords($record['prénom salarié']),
                'lastname' => fn ($record) => ucwords($record['nom salarié']),
                'status' => fn () => 1,
                'registration_number' => fn ($record) => trim($record['matricule salarié']),
                'function' => fn ($record) => trim($record['emploi salarié']) ?: null,
                'phone' => function ($record) {
                    $user = Users::where('registration_number', trim($record['matricule salarié']))->first();
                    $phone = trim($record['téléphone salarié']) ?: null;
                    return $user?->phone ?? $phone;
                },
                'localisations' => function ($record, BridgeContent $bridge) {
                    $uuid = get_entity_reference($record['etablissement'], $bridge, 'localisations');
                    return $uuid ? [$uuid] : [];
                },
                'competences' => function ($record, BridgeContent $bridge) {
                    $uuid = get_entity_reference($record['service - cco (pôle de compétence)'], $bridge, 'competences');
                    return $uuid ? [$uuid] : [];
                },
                'services' => function ($record, BridgeContent $bridge) {
                    if (trim($record['code axe']) === 'NDE') {
                        return [];
                    }

                    $uuid = get_entity_reference($record['libellé axe (services/axe)'], $bridge, 'services');
                    return $uuid ? [$uuid] : [];
                },
                'users' => function ($record) {
                    if (empty($record['matricule responsable'])) {
                        return [];
                    }

                    $uuid = Users::where('registration_number', '=', trim($record['matricule responsable']))->first()?->uuid;

                    return $uuid ? [$uuid] : [];
                },
            ],
        ],
    ],
];
