import { http } from '@inside-library/helpers/Http'

export default {
  offers: {
    add: ({ data }) => ({
      name: 'OfferPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'OffersListingPage' })
  },
  offersCategories: {
    add: () => ({ name: 'OffersListingPage' }),
    delete: () => ({ name: 'OffersListingPage' }),
    globalSearch: () => ({ routeAs: 'add' })
  },
  articleBlog: {
    add: () => ({ name: 'ConfuciusPage' }),
    delete: () => ({ name: 'ConfuciusPage' })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  },
  spacesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.data[0].slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.sspaces.data[0].slug[0] }
    })
  },
  linksSpaces: {
    fields: [{ spaces_categories: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces_categories.data[0].spaces.data[0].slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces_categories.data[0].spaces.data[0].slug[0] }
    })
  },
  jobsPage: {
    fields: [{ spaces_categories: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'JobsPage',
      params: {
        slug: data.spaces_categories.data[0].spaces.data[0].slug[0],
        jobs: data.slug[0]
      }
    }),
    delete: ({ data }) => ({
      name: 'JobsPage',
      params: { slug: data.spaces_categories.data[0].spaces.data[0].slug[0] }
    })
  },
  domainsPage: {
    fields: ['slug'],
    add: async ({ data }) => {
      const { data: jobsPage } = await http.get('content/jobs_page', {
        fields: ['uuid', 'slug', { spaces_categories: [{ spaces: ['slug'] }] }],
        filters: { domains_page: { 'uuid:eq': data.uuid } }
      })

      return {
        name: 'DomainPage',
        params: {
          slug: jobsPage[0].spaces_categories.data[0].spaces.data[0].slug[0],
          jobs: jobsPage[0].slug[0],
          domain: data.slug[0]
        }
      }
    },
    delete: async ({ data }) => {
      const { data: jobsPage } = await http.get('content/jobs_page', {
        fields: ['uuid', 'slug', { spaces_categories: [{ spaces: ['slug'] }] }],
        filters: { domains_page: { 'uuid:eq': data.uuid } }
      })

      return {
        name: 'JobsPage',
        params: {
          slug: jobsPage[0].spaces_categories.data[0].spaces.data[0].slug[0],
          jobs: jobsPage[0].slug[0]
        }
      }
    }
  },
  domains: {
    fields: [{ domains_page: ['slug'] }],
    add: async ({ data }) => {
      const { data: jobsPage } = await http.get('content/jobs_page', {
        fields: ['uuid', 'slug', { spaces_categories: [{ spaces: ['slug'] }] }],
        filters: { domains_page: { 'uuid:eq': data.uuid } }
      })

      return {
        name: 'DomainPage',
        params: {
          slug: jobsPage[0].spaces_categories.data[0].spaces.data[0].slug[0],
          jobs: jobsPage[0].slug[0],
          domain: data.domains_page.slug[0]
        }
      }
    },
    delete: async ({ data }) => {
      const { data: jobsPage } = await http.get('content/jobs_page', {
        fields: ['uuid', 'slug', { spaces_categories: [{ spaces: ['slug'] }] }],
        filters: { domains_page: { 'uuid:eq': data.uuid } }
      })

      return {
        name: 'DomainPage',
        params: {
          slug: jobsPage[0].spaces_categories.data[0].spaces.data[0].slug[0],
          jobs: jobsPage[0].slug[0],
          domain: data.domains_page.slug[0]
        }
      }
    }
  },
  entities: {
    add: ({ data }) => ({
      name: 'EntityPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'EntityListingPage'
    })
  },
  corporates: {
    add: ({ data }) => ({
      name: 'CorporatePage',
      params: { slug: data.slug[0] }
    })
  },
  managerSpacesEvents: {
    add: ({ data }) => ({
      name: 'EventsManagerPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'EventsCalendarManagerPage'
    })
  },
  managerEventsCategories: {
    add: () => ({
      name: 'EventsCalendarManagerPage'
    }),
    delete: () => ({
      name: 'EventsCalendarManagerPage'
    })
  },
  managerSpacesFolders: {
    add: () => ({
      name: 'GedManagerPage'
    }),
    delete: () => ({
      name: 'GedManagerPage'
    }),
    globalSearch: () => ({ routeAs: 'add' })
  },
  cardsLinks: {
    add: () => ({ path: '/' })
  }
}
