import { markRaw } from 'vue'

import { Title } from 'inside-collection/atoms'

export default {
  components: { Title },
  data() {
    return {
      m_categoriesConfig: {
        movements_categories: {
          data: (data, contentType, { getData }) => getData(data, contentType),
          style: 'tag',
          disabledOn: ['NominationPage']
        },
        entities: {
          data: (data, contentType, { getData }) => getData(data, contentType),
          href: data => `/${data.slug[0]}`
        }
      }
    }
  },
  methods: {
    m_fullOverrides(data, { deleteItems, addItemAfter }) {
      deleteItems('bookmarks')

      addItemAfter('title', {
        tag: markRaw(Title),
        id: 'function',
        class: 'function',
        data: { tag: 'h5' },
        value: data.function
      })
    }
  }
}
