import { http } from '@inside-library/helpers/Http'

export const fetchSpacePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content',
        'admin',
        'content_type',
        {
          news: {
            fields: [
              'uuid',
              'title',
              'image',
              'published_at',
              'chapo',
              'slug',
              'content_type',
              'total_views',
              'unique_views',
              { reactions: ['count', { users: ['uuid'] }] },
              { comments: ['count'] },
              {
                news_categories: {
                  fields: ['uuid', 'title'],
                  filters: { 'status:eq': 1 }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              reverse: true,
              sort: 'published_at:desc'
            }
          }
        },
        {
          spaces_categories: {
            fields: [
              'uuid',
              'title',
              'image',
              'content_type',
              'weight',
              'admin'
            ],
            filters: {
              'status:eq': 1,
              reverse: true
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchJobsPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/jobs_page', {
      fields: [
        'uuid',
        'admin',
        'title',
        'content_type',
        'content',
        {
          jobs_domains_page: {
            fields: ['uuid', 'title', 'image', 'slug'],
            filters: { 'status:eq': 1, alias: 'data' }
          }
        },
        { spaces_categories: [{ spaces: ['slug', 'title'] }] }
      ],
      filters: { 'slug:eq': $route.params.jobs }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchDomainPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/domains_page', {
      fields: [
        'uuid',
        'admin',
        'title',
        'content_type',
        'content',
        {
          domains: {
            fields: ['uuid', 'title', 'color', 'content_type', 'admin'],
            filters: { reverse: true, alias: 'data' }
          }
        },
        {
          jobs_page: {
            fields: ['slug', 'title'],
            filters: { reverse: true }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.domain }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
