import { http } from '@inside-library/helpers/Http'

export const fetchCorporatePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/corporates', {
      fields: [
        'uuid',
        'title',
        'section_title',
        'content_type',
        'content',
        'admin',
        'slug',
        'image',
        'published_at',
        'website',
        'twitter',
        'linkedin',
        'facebook',
        'instagram',
        'section_website',
        'section_twitter',
        'section_linkedin',
        'section_facebook',
        'section_instagram',
        {
          users: {
            fields: ['uuid', 'firstname', 'lastname', 'image', 'count'],
            filters: { 'status:eq': 1, limit: 12 }
          }
        },
        {
          news: {
            fields: [
              'uuid',
              'title',
              'slug',
              'image',
              'published_at',
              'content_type'
            ],
            filters: { 'status:eq': 1, limit: 8 }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
