import OffersListingPage from '../pages/offers/OffersListingPage'
import OfferPage from '../pages/offers/OfferPage'
import { fetchOffersListing, fetchOffer } from '../components/offers/fetch'

import SpacePage from '../pages/spaces/SpacePage'
import JobsPage from '../pages/spaces/JobsPage'
import DomainPage from '../pages/spaces/DomainPage'
import {
  fetchSpacePage,
  fetchJobsPage,
  fetchDomainPage
} from '../components/spaces/fetch'

import EntityPage from '../pages/entity/EntityPage'
import { fetchEntityPage } from '../components/entity/fetch'

import CorporatePage from '../pages/corporate/CorporatePage'
import { fetchCorporatePage } from '../components/corporate/fetch'

import SpaceManagerPage from '../pages/manager/SpaceManagerPage'
import { fetchSpaceManagerPage } from '../components/manager/fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      bannerData: {
        html: true
      }
    }
  },
  {
    name: 'MapPage',
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      extraFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: true,
      bannerData: {
        page: 'ged',
        introductionKey: 'custom_introduction',
        html: true
      }
    }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    component: () => import('../pages/news/NewsListingPage')
  },
  {
    name: 'NewsPage',
    meta: { disabled: false, content: 'news' },
    component: () => import('@inside-news/components/pages/NewsPage'),
    props: {
      extraFields: ['total_views', 'unique_views'],
      contentOptions: {
        statisticsEnabled: true,
        scaffoldOverrides: (data, { deleteItems }) => {
          deleteItems('bookmarks')
        },
        extraCategoriesConfig: {
          entities: {
            data: (data, contentType, { getData }) => {
              return getData(data, contentType)
            },
            href: data => ({
              name: 'EntityPage',
              params: { slug: data.slug[0] }
            })
          }
        }
      },
      relatedOptions: {
        extraFields: [{ entities: ['title', 'uuid', 'slug'] }],
        componentAttributes: () => ({
          scaffoldOverrides: (data, { deleteItems }) => {
            deleteItems('bookmarks')
          },
          extraCategoriesConfig: {
            entities: {
              data: (data, contentType, { getData }) => {
                return getData(data, contentType)
              },
              href: data => ({
                name: 'EntityPage',
                params: { slug: data.slug[0] }
              })
            }
          }
        })
      }
    }
  },
  {
    name: 'EventsCalendarPage',
    component: () => import('../pages/events/EventCalendarPage'),
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false },
    props: {
      extraFields: ['total_views', 'unique_views']
    }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'TeamsListingPage',
    meta: { disabled: false },
    props: {
      bannerData: {
        size: 's',
        add: ['groups'],
        html: true
      }
    }
  },
  {
    name: 'SpaceManagerPage',
    path: '/espace-manager/:slug',
    component: withFetch(SpaceManagerPage, { size: 'xxl' })(
      fetchSpaceManagerPage
    ),
    meta: { content: 'manager-spaces' }
  },
  {
    name: 'EventsCalendarManagerPage',
    path: '/espace-manager/:slug/evenements-manager',
    component: () => import('../pages/manager/EventsCalendarManagerPage')
  },
  {
    name: 'EventsManagerPage',
    path: '/evenements-manager/:slug',
    component: () => import('@inside-events/components/pages/EventPage'),
    meta: { disabled: false },
    props: {
      contentType: 'manager_spaces_events',
      fieldsContentType: 'events',
      extraFields: [
        {
          manager_events_categories: {
            fields: ['uuid', 'title', 'slug', 'color'],
            filters: { 'status:eq': 1 }
          }
        }
      ],
      configModule: 'inside-events',
      useRelatedSlot: false,
      back: { href: { name: 'EventsCalendarManagerPage' } }
    }
  },
  {
    name: 'GedManagerPage',
    path: '/bibliotheque-de-l-espace-manager',
    component: () => import('../pages/manager/GedManagerPage'),
    meta: { disabled: false }
  },
  {
    name: 'OffersListingPage',
    path: '/leboncoin-primonial',
    component: withFetch(OffersListingPage, { watch: true })(fetchOffersListing)
  },
  {
    name: 'OfferPage',
    path: '/leboncoin-primonial/:slug',
    component: withFetch(OfferPage, { watch: true })(fetchOffer),
    meta: { content: 'offers' }
  },
  {
    name: 'NominationsListingPage',
    path: '/arrivees-et-evolutions',
    component: () => import('@inside-news/components/pages/ListingPage'),
    props: {
      contentType: 'movements',
      bannerData: {
        page: 'newcomers',
        add: ['movements', 'movements_categories'],
        html: true,
        introductionKey: 'custom_introduction'
      },
      contentRoot: {
        movements: item => ({
          name: 'NominationPage',
          params: { slug: item.slug[0] }
        })
      },
      filtersInput: 'selectbox',
      categoriesFields: [
        {
          movements_categories: {
            fields: ['uuid', 'title', 'slug', 'content_type'],
            filters: { 'status:eq': 1, sort: 'title:asc' }
          }
        }
      ],
      extraFields: [
        'function',
        'total_views',
        'unique_views',
        {
          movements_categories: ['uuid', 'title', 'color', 'slug']
        },
        {
          entities: ['uuid', 'title', 'slug']
        }
      ],
      componentAttributes: () => ({
        categoriesConfig: {
          movements_categories: {
            data: (data, contentType, { getData }) =>
              getData(data, contentType),
            style: 'tag',
            disabledOn: ['NominationsListingPage']
          },
          entities: {
            data: (data, contentType, { getData }) => {
              return getData(data, contentType)
            },
            href: data => `/${data.slug[0]}`
          }
        },
        scaffoldOverrides: (data, { deleteItems, replaceItem }) => {
          deleteItems('bookmarks')

          replaceItem('chapo', {
            value: data.function,
            hideIf: () => !data.function
          })
        }
      })
    }
  },
  {
    name: 'NominationPage',
    path: '/arrivees-et-evolutions/:slug',
    component: () => import('../pages/movement/MovementPage'),
    meta: { content: 'movements' }
  },
  {
    name: 'NewcomersListingPage',
    props: {
      bannerData: { add: ['movements'], html: true }
    }
  },
  {
    name: 'DirectoryPage',
    path: '/annuaire-des-collaborateurs',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ConfuciusPage',
    path: '/confucius',
    component: () => import('../pages/confucius/ConfuciusPage')
  },
  {
    name: 'SpacePage',
    path: '/espace/:slug',
    component: withFetch(SpacePage, { size: 'xxl' })(fetchSpacePage),
    meta: { content: 'spaces' }
  },
  {
    name: 'JobsPage',
    path: '/espace/:slug/:jobs',
    component: withFetch(JobsPage, { size: 'xxl' })(fetchJobsPage)
  },
  {
    name: 'DomainPage',
    path: '/espace/:slug/:jobs/:domain',
    component: withFetch(DomainPage, { size: 'xxl' })(fetchDomainPage)
  },
  {
    name: 'EntityListingPage',
    path: '/le-groupe-de-a-a-z',
    component: () => import('../pages/entity/EntityListingPage')
  },
  {
    name: 'EntityPage',
    path: '/le-groupe-de-a-a-z/:slug',
    component: withFetch(EntityPage, { size: 'xxl' })(fetchEntityPage)
  },
  {
    name: 'GroupsListingPage',
    path: '/ressources-humaines',
    component: () => import('../pages/groups/GroupsListingPage')
  },
  {
    name: 'CorporatePage',
    path: '/corporate/:slug',
    component: withFetch(CorporatePage, { size: 'xxl' })(fetchCorporatePage)
  },
  {
    name: 'ActivitiesPage',
    path: '/activites',
    component: () => import('../pages/activities/ActivitiesPage')
  },
  {
    name: 'SimplePage',
    meta: {
      disabled: false
    }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
