import { markRaw } from 'vue'

import RatioImageUi from '@inside-ui/RatioImageUI'
import { BaseText } from 'inside-collection/atoms'

export default {
  components: { RatioImageUi, BaseText },
  props: {
    content_type: {
      type: String
    }
  },
  data() {
    return {
      m_categoriesConfig: {
        offers_categories: {
          data: (data, contentType, { getData }) => {
            return getData(data, contentType)
          },
          style: 'tag',
          disabledOn: ['OffersListingPage', 'OfferPage'],
          href: item => ({
            name: 'OffersListing',
            query: { offers_categories: item.uuid }
          })
        },
        localisations: {
          data: (data, contentType, { getData }) => {
            return getData(data, contentType)
          },
          disabledOn: ['OffersListingPage', 'OfferPage'],
          href: item => ({
            name: 'OffersListingPage',
            query: { localisations: item.uuid }
          })
        }
      }
    }
  },
  methods: {
    m_capsuleOverrides(data, { replaceItem }) {
      if (!data.image) {
        replaceItem('link', {
          id: 'link',
          tag: 'router-link',
          class: 'main-image',
          ...(data.offers_categories.data[0].image && {
            children: [
              {
                id: 'image',
                tag: markRaw(RatioImageUi),
                data: {
                  src: data.offers_categories.data[0].image.small
                }
              }
            ]
          })
        })
      }
    },
    m_fullOverrides(data, { deleteItems, replaceItem }) {
      deleteItems('bottom-actions', 'likes', 'statistics', 'comments', 'print')

      replaceItem('bookmarks', {
        tag: 'bookmark-ui',
        id: 'favorites',
        data: {
          heritedData: {
            type: 'bookmark',
            related_uuid: data.uuid,
            related_type: data.content_type,
            reactions: data.reactions
          }
        }
      })
    }
  }
}
