export default {
  'inside-commons': {
    banner: {
      introductionKey: 'custom_introduction',
      html: true
    }
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-edition': {
    showParagraphsLabel: true
  },
  'inside-ged': {
    allowReportPictures: true,
    rootRoute: {
      fr: 'bibliotheque'
    }
  },
  'inside-news': {
    bookmarkEnabled: false,
    showStatistics: true,
    statisticsEnabled: true
  },
  'inside-events': {
    statisticsEnabled: true,
    subscriptionEnabled: true,
    rootRoute: {
      fr: 'evenements-du-groupe'
    }
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ],
      extraTabs: store => {
        if (
          store.getters.getUserInfos.permissions.roles.includes(
            'super_administrator'
          )
        ) {
          return [
            {
              name: 'confucius',
              restrictions: [],
              icon: 'news',
              route: 'ConfuciusPage'
            },
            {
              name: 'administration',
              restrictions: [],
              icon: 'settings',
              link: {
                fr: '/settings/contenus'
              }
            }
          ]
        } else if (
          store.getters.getUserInfos.permissions.add.includes('article_blog')
        ) {
          return [
            {
              name: 'confucius',
              restrictions: [],
              icon: 'news',
              route: 'ConfuciusPage'
            }
          ]
        } else {
          return []
        }
      }
    },
    shortcuts: {
      max: 8,
      readonlyCount: 3
    }
  },
  'inside-teams': {
    rootRoute: {
      fr: 'communautes'
    }
  },
  'inside-tools': {
    rootRoute: {
      fr: 'outils-et-liens-utiles-primonial'
    }
  },
  'inside-maps': {
    rootRoute: {
      fr: 'implantations'
    }
  },
  'inside-layouts': {
    logoMaxWidth: 'l',
    templates: {
      fullContent: {
        news: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () =>
            import('@inside-news/components/lib/Minimal.vue')
        },
        movements: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () =>
            import('@inside-news/components/lib/Minimal.vue')
        }
      }
    }
  },
  'inside-workflows': {
    isEnabled: true
  },
  globals: {
    notificationRedirectionsContentTypes: ['offers'],
    notificationRedirections: {
      offers: async ({ data }) => ({
        name: 'OfferPage',
        params: {
          slug: data.slug[0]
        }
      }),
      news: async ({ data }) => ({
        name: 'NewsPage',
        params: {
          slug: data.slug[0]
        }
      }),
      movements: async ({ data }) => ({
        name: 'NominationPage',
        params: {
          slug: data.slug[0]
        }
      })
    }
  }
}
