import insideConfig from './inside.config.js'
import i18n from './i18n'
import redirections from './redirections'
import routes from './router'

import HorizontalLayouts from '../inside-overrides/inside-layouts/HorizontalLayouts'
import SpaceButtonParagraph from '../inside-overrides/inside-library/paragraphs/SpaceButtonParagraph'
import SpaceLinksParagraph from '../inside-overrides/inside-library/paragraphs/SpaceLinksParagraph'
import SpaceLogoParagraph from '../inside-overrides/inside-library/paragraphs/SpaceLogoParagraph'
import SpaceToolsParagraph from '../inside-overrides/inside-library/paragraphs/SpaceToolsParagraph'
import SpaceUsersParagraph from '../inside-overrides/inside-library/paragraphs/SpaceUsersParagraph'
import SearchActions from '../inside-overrides/inside-searches/SearchActions'
import UserModal from '../inside-overrides/inside-users/modals/UserModal'

export default {
  name: 'inside-customs',
  init: app => {
    app.component('horizontal-layouts', HorizontalLayouts)
    app.component('space-button-paragraph', SpaceButtonParagraph)
    app.component('space-links-paragraph', SpaceLinksParagraph)
    app.component('space-logo-paragraph', SpaceLogoParagraph)
    app.component('space-tools-paragraph', SpaceToolsParagraph)
    app.component('space-users-paragraph', SpaceUsersParagraph)
    app.component('search-actions', SearchActions)
    app.component('user-modal', UserModal)
  },
  insideConfig,
  i18n,
  redirections,
  routes
}
