import { http } from '@inside-library/helpers/Http'

export const fetchSpaceManagerPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/manager_spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content',
        'admin',
        'content_type'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
