import { http } from '@inside-library/helpers/Http'

const fetchNewsSlider = async () => {
  try {
    const { data } = await http.get('content/news', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'updated_at',
        'chapo',
        'slug',
        'content_type',
        'is_featured',
        'total_views',
        'unique_views',
        { entities: ['uuid', 'title', 'slug'] },
        { reactions: ['count', { users: ['uuid'] }] },
        { comments: ['count'] },
        {
          news_categories: {
            fields: ['uuid', 'title'],
            filters: { 'status:eq': 1 }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'is_featured:eq': 1,
        sort: 'published_at:desc',
        'published_at:lte': 'now()',
        limit: 4
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchOffersListing = async () => {
  try {
    const { data } = await http.get('content/offers', {
      fields: [
        'uuid',
        'published_at',
        'updated_at',
        'title',
        'chapo',
        'image',
        'slug',
        'content_type',
        'content',
        'localisations',
        'email_address',
        {
          offers_categories: {
            fields: ['uuid', 'title', 'color', 'content_type', 'image'],
            filters: { 'status:eq': 1 }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        'published_at:lte': 'now()',
        limit: 3
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchNewsSlider, fetchOffersListing }
