import { http } from '@inside-library/helpers/Http'

export const fetchEntityPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/entities', {
      fields: [
        'uuid',
        'title',
        'content_type',
        'content',
        'admin',
        'slug',
        'image',
        'published_at',
        'website',
        'twitter',
        'linkedin',
        'facebook',
        'instagram',
        {
          users: {
            fields: ['uuid', 'firstname', 'lastname', 'image', 'count'],
            filters: { 'status:eq': 1, limit: 12, reverse: true }
          }
        },
        {
          news: {
            fields: [
              'uuid',
              'title',
              'slug',
              'image',
              'published_at',
              'content_type'
            ],
            filters: { 'status:eq': 1, limit: 8, reverse: true }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
