export default {
  // regular GED
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: { users: ['uuid'] } }
    ]
  },
  domains: {
    modalFields: ['uuid', 'title', 'content']
  },
  // manager_spaces GED
  manager_spaces_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: { users: ['uuid'] } }
    ]
  },
  modal: {
    modalFields: ['class', 'content']
  },
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'image',
      'email',
      'lastname',
      'firstname',
      'function',
      'phone',
      'mobile_phone',
      { services: ['title'] },
      { entities: ['title'] },
      { locations: ['title'] },
      { countries: ['title'] },
      'uuid',
      'hobbies',
      {
        'users.users': {
          fields: ['firstname', 'lastname', 'uuid', 'function', 'image'],
          filters: {
            'status:eq': 1,
            'is_maintenance:eq': 0,
            reverse: true,
            alias: 'coworkers'
          }
        }
      },
      {
        users: {
          fields: ['firstname', 'lastname', 'uuid', 'function', 'image']
        }
      }
    ]
  },
  groups_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'created_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { groups_folders: ['title'] }
    ]
  }
}
