<?php

namespace Inside\IPRI\Providers;

use Inside\Content\Events\ContentUpdatedEvent;
use Inside\IPRI\Console\ExportTools;
use Inside\IPRI\Http\Middleware\IpriMiddleware;
use Inside\IPRI\Listeners\ArticleBlogUpdatedListener;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentUpdatedEvent::class => [
            ArticleBlogUpdatedListener::class,
        ],
    ];

    protected array $commands = [
        ExportTools::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeConfigTo(__DIR__.'/../../config/entities.php', 'entities');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeConfigTo(__DIR__.'/../../config/user_references.php', 'user_references');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        $this->app->middleware([
            IpriMiddleware::class,
        ]);
    }
}
