<?php

namespace Inside\IPRI\Listeners;

use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Content\Models\Contents\ArticleBlog;
use Inside\Host\Bridge\BridgeContent;
use Inside\Notify\Listeners\BaseNotificationListener;

/**
 * Content updated listener
 *
 * @category Class
 * @package  Inside\Notify\Listeners\ContentUpdatedListener
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     https://www.maecia.com/
 */
class ArticleBlogUpdatedListener extends BaseNotificationListener
{
    public function handle(ContentUpdatedEvent $event): void
    {
        $model = $event->model;

        if (!$model instanceof ArticleBlog) {
            return;
        }

        if (! data_get($model, 'is_headline')) {
            return;
        }

        $bridge = new BridgeContent();
        ArticleBlog::withoutEvents(
            function () use ($bridge, $model) {
                $articles = ArticleBlog::withoutGlobalScopes()->where('is_headline', 1)->where('uuid', '!=', $model->uuid)->get();
                foreach ($articles as $article) {
                    $bridge->contentUpdate(
                        'article_blog',
                        [
                            'uuid'        => $article->uuid,
                            'is_headline' => false,
                        ]
                    );
                }
            }
        );
    }
}
