<?php

namespace Inside\IPRI\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;
use Inside\Content\Models\Contents\Tools;

class ExportTools extends Command
{
    private const PUBLIC_IMAGE_FOLDER = 'menus/maintenance';

    /**
     * @var string
     */
    protected $name = 'ipri:export-tools';

    /*
   * @var string
   */
    protected $signature = 'ipri:export-tools';

    /**
     * @var string
     */
    protected $description = 'Export tools';

    public function __construct()
    {
        parent::__construct();
    }

    private function getPublicImage(?string $imagePath): string | false
    {
        if (! $imagePath || ! Storage::disk('local')->exists($imagePath)) {
            return false;
        }

        $publicPath = self::PUBLIC_IMAGE_FOLDER.'/'.basename($imagePath);
        Storage::disk('local')->copy($imagePath, $publicPath);

        return $publicPath;
    }

    /**
     * Import users
     */
    public function handle(): void
    {
        if (Storage::disk('local')->exists(self::PUBLIC_IMAGE_FOLDER)) {
            Storage::disk('local')->deleteDirectory(self::PUBLIC_IMAGE_FOLDER);
        }

        Storage::disk('local')->makeDirectory(self::PUBLIC_IMAGE_FOLDER);

        $tools = Tools::query()
            ->where('langcode', config('app.locale'))
            ->where('status', 1)
            ->orderBy('title')
            ->get()
            ->map(fn (Tools $tool) => [
                'title' => $tool->title,
                'link' => $tool->tools_link,
                'image' => $this->getPublicImage($tool->image),
            ]);

        Storage::put('tools.json', $tools->toJson() ?: '');
    }
}
