@php
    $json = file_get_contents('storage/app/tools.json');
    $tools = json_decode($json, true);
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>@yield('title')</title>
    <style>
        @import url("https://fonts.googleapis.com/css2?family=Lato:wght@400;600;700&display=swap");

        main {
            width: 100%;
            height: 100%;
            background-color: white;
            margin: 0;
        }

        body {
            width: 100%;
            height: 100%;
            margin: 0;
        }

        .title {
            font-family: 'Lato';
            font-weight: 700;
        }

        .marge {
            padding-left: 10%;
            padding-right: 10%;
        }

        .paragraph {
            font-family: 'Lato';
        }

        .img-container {
            display: flex;
            justify-content: center;
            align-content: center;
            flex-direction: column;
            background-image: url('vendor/maecia/ipri-back/resources/assets/img/maintenance/header.jpg');
            background-repeat: no-repeat;
            background-position: center;
            padding: 2% 30%;
        }

        .banner-write {
            color: white;
            text-align: center;
        }

        .brand-logo {
            max-width: 15%;
            margin: auto;
            padding-bottom: 1%;
        }

        .logo {
            max-width: 25%;
            max-height: 50%;
            margin-top: 7%;
        }

        .card {
            box-shadow: 5px 5px 5px whitesmoke;
            width: 90%;
            margin: 5%;
            display: flex;
            flex-direction: row;
            text-decoration: none;
            color: #5a5a5a;
        }

        .card img {
            max-height: 45px;
            max-width: 45px;
            vertical-align: middle;
        }

        .cards-container {
            display: flex;
            width: 100%;
            flex-direction: row;
            display: grid;
            grid-template-columns: repeat(4, 1fr);
        }

        .card-img-container {
            display: flex;
            justify-content: center;
            flex-direction: column;
        }

        .card-title {
            font-family: 'Lato';
            margin: 10% 5%;
            font-size: 17px;
        }

        .footer {
            position: absolute;
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            flex: 1;
            width: 100%;
            height: 10vh;
        }

        .footer-rs {
            display: flex;
            flex-direction: row;
            justify-content: center;
            align-items: center;
            width: 100%;
        }

        .rs-link {
            text-decoration: none;
            color: grey;
            font-family: Lato;
            margin: 0 2%;
            display: flex;
        }

        .footer-logo {
            max-width: 50%;
            margin-left: 25%;
        }

        .footer-logo-container {
            margin-top: 2%;
            width: 100%;
        }

        .footer-logo-right {
            text-align: right;
        }

        .rs-name {
            font-family: Lato;
        }

        .rs-container {
            display: flex;
            flex: 1;
            flex-direction: row;
            justify-content: center;
            align-items: center;
        }

        .header-container {
            display: flex;
            align-items: center;
            justify-items: center;
            width: 100%;
            height: 10%;
            margin-top: 30px;
        }

        @media (max-width: 1024px) {
            .img-container {
                padding: 2% 10%;
            }

            .brand-logo {
                max-width: 40%;
                margin: auto;
            }

            .cards-container {
                grid-template-columns: repeat(3, 1fr);
            }
        }

        @media (max-width: 764px) {
            .footer {
                display: flex;
                flex-direction: column;
                justify-content: space-between;
                flex: 1;
                width: 100%;
                height: 10%;
            }

            .footer-rs {
                flex-direction: column;
            }

            .footer-logo {
                max-width: 50%;
            }

            .footer-logo-container {
                justify-self: center;
                align-self: center;
                justify-content: center;
                align-content: center;
                align-items: center;
                justify-items: center;
            }

            .footer-client-logo {
                display: flex;
                align-self: center;
                width: 15%;
                margin-left: 43%;
            }

            .cards-container {
                grid-template-columns: repeat(2, 1fr);
            }

        }

        @media (max-width: 480px) {
            .cards-container {
                grid-template-columns: repeat(1, 1fr);
            }

            .img-container {
                background-image: none;
                background-color: #E50052;
                height: auto;
                padding: 2% 30%;
            }
        }
    </style>
</head>

<body>
<main>
    <div class="header-container">
        <img class='brand-logo' src='vendor/maecia/ipri-back/resources/assets/img/maintenance/logo.png' alt="logo_ipri" />
    </div>
    <div class='img-container'>
        <div class='banner-write'>
            <h1 class='title'> Intranet en maintenance</h1>
            <p class='paragraph'>L'intranet est momentanément indisponible. Nous mettons tout en oeuvre pour rétablir l'accès le plus rapidement possible. En attendant retrouvez vos outils ci-dessous.</p>
        </div>
    </div>
    <div class="marge">
        <div id='cards' class='cards-container'>
            @foreach ($tools as $tool)
                <a class="card" target="_blank" href="{{ $tool['link'] }}">
                    @if ($tool['image'])
                        <span class="card-img-container">
                            <img src="{{ $tool['image'] }}" />
                        </span>
                    @endif
                    <h2 class='card-title'>{{ $tool['title'] }}</h2>
                </a>
            @endforeach
        </div>
    </div>
    <div class='footer'>
        <div class="footer-logo-container">
            <img class="footer-client-logo" src="vendor/maecia/ipri-back/resources/assets/img/maintenance/LogoClient.png" alt="logo">
        </div>
        <div class="footer-rs">
            <a class="rs-link" href="https://fr-fr.facebook.com/pages/category/Financial-Service/Primonial-182259035223442/" target="_blank">
                <img class="rs-img" src="vendor/maecia/ipri-back/resources/assets/img/maintenance/facebook.svg" alt="facebook" />
                <p class="rs-name">Facebook</p>
            </a>
            <a class="rs-link" href="https://twitter.com/primonial?lang=fr" target="_blank">
                <img class="rs-img" src="vendor/maecia/ipri-back/resources/assets/img/maintenance/twitter.svg" alt="twitter.svg" />
                <p class="rs-name">Twitter</p>
            </a>
            <a class="rs-link" href="https://fr.linkedin.com/company/groupeprimonial" target="_blank">
                <img class="rs-img" src="vendor/maecia/ipri-back/resources/assets/img/maintenance/linkedin.svg" alt="linkedin.svg" />
                <p class="rs-name">Linkedin</p>
            </a>
            <a class="rs-link" href="https://www.youtube.com/channel/UCN92tNuAEP4X0RlcmoGadfw" target="_blank">
                <img class="rs-img" src="vendor/maecia/ipri-back/resources/assets/img/maintenance/youtube.svg" alt="youtube.svg" />
                <p class="rs-name">Youtube</p>
            </a>
            <a class="rs-link" href="/protection-des-donnees" target="_blank">
                <img class="rs-img" src="vendor/maecia/ipri-back/resources/assets/img/maintenance/email.svg" alt="email.svg" />
                <p class="rs-name">Protection des données</p>
            </a>
        </div>
        <div class="footer-logo-container footer-logo-right">
            <img class="footer-logo" src="vendor/maecia/ipri-back/resources/assets/img/maintenance/CreationInsideSimple.png" alt="logo">
        </div>
    </div>
</main>
</body>
</html>
