<?php

namespace Inside\IPRI\Seeders;

use Illuminate\Database\Seeder;
use Inside\Content\Events\ContentCreatedEvent;
use Inside\Content\Models\Contents\News;
use Inside\Notify\Models\NotificationType;

class DeleteFeaturedNewsNotification extends Seeder
{
    public function run(): void
    {
        $types = NotificationType::where('event', ContentCreatedEvent::class)
            ->where('model', News::class)
            ->whereIn('action', ['create', 'createOrUpdate'])
            ->where('condition', 'is_featured:1|status:1')
            ->get();

        /** @var NotificationType $type */
        foreach ($types as $type) {
            $type->delete();
        }
    }
}
