<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\ToolsCategories;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Users;

class UpdateDefaultToolsForIpri extends Migration
{
    public function up(): void
    {
        $defaultTools = [
            "Artemis" => 0,
            "Crystal'TALENTS" => 1,
            "Yooz" => 2
        ];

        $allTools = Tools::query()
            ->whereIn('title', array_keys($defaultTools))
            ->get()
            ->sortBy(fn ($tool) => $defaultTools[$tool->title]);

        $defaultToolsUuids = $allTools->map(
            fn ($tool) => ['target_uuid' => $tool->uuid_host]
        )->toArray();

        $bridge = new BridgeContent();
        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'tools',
            options: [
                'title' => [
                    'fr' => 'Accès rapide',
                    'en' => 'Quick access'
                ],
                'default' => $defaultToolsUuids
            ]
        );

        Users::all()->each(fn ($user) => $bridge->updateReferenceFields(
            type: 'users',
            contentUuidHost: $user->uuid_host,
            data: [
                'tools' => $defaultToolsUuids
            ]
        ));
    }
}
