<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema as InsideSchema;

class RemoveIsStoneUserToUsers extends Migration
{
    public function up(): void
    {
        if (! InsideSchema::hasField(modelName: 'users', fieldName: 'is_stone_user')) {
            return;
        }

        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField(
            'user',
            'user',
            'is_stone_user',
        );

        Artisan::call('models:rebuild');
    }
}
