<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class SetNewDefaultUsersTools extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $data = [];

        collect([
            [
                'fr' => 'Primonial Talents',
                'en' => 'Primonial Talents',
                'de' => 'Primoniale Talente',
                'link' => 'https://talents.primonial.fr/#/home'
            ],
            [
                'fr' => 'Mes entretiens',
                'en' => 'My Interviews',
                'de' => 'Meine Interviews',
                'link' => 'https://login.microsoftonline.com/71eb3a91-4ce0-4f56-9227-250f917ef487/saml2'
            ]
        ])->each(function ($tool) use ($bridge, &$data) {
            if (!($uuidHost = Tools::where('title', $tool['fr'])->where('langcode', 'fr')->value('uuid_host'))) {
                $uuid = $bridge->contentInsert('tools', [
                    'status' => 1,
                    'langcode' => 'fr',
                    'title' => $tool['fr'],
                    'tools_link' => $tool['link']
                ]);
                $uuidHost = Tools::findOrFail($uuid)->value('uuid_host');
            }

            $data[] = $uuid ?? Tools::where('uuid_host', $uuidHost)->where('langcode', 'fr')->firstOrFail()->uuid;

            collect(['en', 'de'])->each(function ($language) use ($bridge, $uuidHost, $tool, &$data) {
                $uuid = $bridge->contentInsert('tools', [
                    'status' => 1,
                    'langcode' => $language,
                    'title' => $tool[$language],
                    'tools_link' => $tool['link'],
                    'uuid_host' => $uuidHost
                ]);
                $data[] = $uuid;
            });
        });

        Users::each(function ($user) use ($bridge, $data) {
            $artemis = Tools::where('title', 'Artemis')->where('langcode', $user->langcode)->pluck('uuid');
            $wanted = Tools::where('langcode', $user->langcode)
                ->whereIn('uuid', $data)
                ->pluck('uuid');

            $tools = $artemis->concat($wanted);
            $existingTools = $user->tools
                ->whereNotIn('uuid', $tools->toArray())
                ->where('title', '!==', 'Fondation Groupe Primonial')
                ->pluck('uuid')
                ->take(3);

            $bridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'tools' => $tools->concat($existingTools)->toArray()
            ]);
        });

        Tools::query()
            ->where('title', 'Fondation Groupe Primonial')
            ->each(fn ($tool) => $bridge->contentDelete('tools', $tool->uuid));
    }
}
