<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class FixUsersFrFieldsLabels extends Migration
{
    public function up(): void
    {
        $fields = [
            'is_maintenance' => [
                'title' => [
                    'fr' => 'Compte de maintenance ?',
                    'en' => 'Maintenance account?',
                    'de' => 'Wartungskonto?',
                ]
            ],
            'send_mail' => [
                'title' => [
                    'fr' => 'Envoyer un mail de création de mot de passe',
                    'en' => 'Send password creation mail',
                    'de' => 'Senden Sie eine E-Mail zur Passworterstellung',
                ],
            ],
            'is_stone_user' => [
                'title' => [
                    'fr' => 'Utilisateur Stone',
                    'en' => 'Stone user',
                    'de' => 'Benutzer Stone',
                ],
            ]
        ];

        $bridge = new BridgeContentType();

        collect($fields)->each(fn ($titles, $fieldName) => $bridge->updateFieldOptions('users', $fieldName, $titles));
    }
}
