<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class SetDefaultUsersTools extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        $artemis = Tools::query()->where('title', 'Artemis')->get();

        if ($artemis->count() !== 3) {
            $bridge->contentInsert('tools', [
                'status' => 1,
                'langcode' => 'de',
                'title' => 'Artemis',
                'tools_link' => 'https://artemis.primonial.fr/#/home',
                'uuid_host' => $artemis->where('langcode', 'fr')->first()?->uuid_host,
            ]);
        }

        $tools = Tools::query()->where('title', 'Artemis')->orWhere('title', 'Fondation Groupe Primonial')->get();

        Users::all()->each(function ($user) use ($tools, $bridge) {
            $wanted = $tools->where('langcode', $user->langcode)->sortBy('title')->pluck('uuid');
            $keep = $user->tools->pluck('uuid')->diff($wanted);

            $bridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'tools' => $wanted->concat($keep)->toArray()
            ]);
        });
    }
}
