<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class SetSecondUsersTools extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $fondationTools = Tools::query()->where('title', 'Fondation Groupe Primonial')->get();
        if ($fondationTools->isEmpty()) {
            // create tool
            $fondationToolsUuid = $bridge->contentInsert('tools', [
                'status' => 1,
                'langcode' => 'fr',
                'title' => 'Fondation Groupe Primonial',
                'tools_link' => 'https://www.primonial.com/',
            ]);
            // create translations
            $fondationTools = Tools::query()->where('uuid', $fondationToolsUuid)->get();
            foreach (['en', 'de'] as $lang) {
                $bridge->contentInsert('tools', [
                    'status' => 1,
                    'langcode' => $lang,
                    'title' => 'Fondation Groupe Primonial',
                    'tools_link' => 'https://www.primonial.com/',
                    'uuid_host' => $fondationTools->first()->uuid_host,
                ]);
            }
        }
    }
}
