<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Languages;
use Inside\Content\Models\Contents\News;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class EditAutomaticTranslations extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('languages');
        $this->migrateContent('news');

        $bridge = new BridgeContent();
        $languages = list_languages();

        foreach ($languages as $language) {
            $host = null;
            foreach ($languages as $langcode) {
                if ($language === $langcode) {
                    continue;
                }
                $datas = [
                    'type' => 'node',
                    'bundle' => 'languages',
                    'langcode' => $langcode,
                    'title' => $language
                ];
                if ($host) {
                    $datas = array_merge($datas, ['uuid_host' => $host]);
                }
                $uuid = $bridge->contentInsert('languages', $datas);
                if (!$host) {
                    $content = Languages::find($uuid);
                    $host = $content->uuid_host;
                }
            }
        }

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
