<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\News;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AddIntroductionFieldToCustomPages extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new \Inside\Host\Bridge\BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField('custom', 'custom_introduction', [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'custom_introduction',
            'searchable'          => true,
            'translatable'        => true,
            'search_result_field' => true,
            'required'            => true,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'de' => 'Einführung',
            ],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
            ],
        ]);
    }

    public function down(): void
    {
    }
}
