<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddManagerSpacesFieldToManagerSpacesFolders extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField('manager_spaces_folders', 'manager_spaces', [
            'name' => 'manager_spaces',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Espace parent',
                'en' => 'Parent space',
                'de' => 'Elternbereich'
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['manager_spaces'],
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
