<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixIntroductionFieldToCustomPages extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField('custom', 'custom_introduction', [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'custom_introduction',
            'searchable'          => true,
            'translatable'        => true,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'de' => 'Einführung',
            ],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
            ],
        ]);
    }
}
