<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;

class MakeContentFieldsUntranslatable extends Migration
{
    use HasConsole;
    public function up(): void
    {
        $contentTypes = \Inside\Content\Facades\Schema::getAllFieldsListingOfType('section');

        $bridge = new BridgeContentType();

        foreach ($contentTypes as $contentType => $fields) {
            foreach ($fields as $field) {
                $this->writeln('Changing ' . $field . ' field for content type ' . $contentType);
                $options = \Inside\Content\Facades\Schema::getFieldOptions($contentType, $field);

                if (!$options) {
                    continue;
                }

                $options['translatable'] = false;
                $bridge->updateFieldOptions($contentType, $field, ['translatable' => false]);
            }
        }

        Artisan::call('cache:clear');
        Artisan::call('models:rebuild');
    }

    public function down(): void
    {
    }
}
