<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;

class AddStoneContentsAndTranslations extends Migration
{
    public function up(): void
    {
        $contentMapping = [
            'stone_main_menu_links' => [
                [
                    'title' => [
                        'fr' => 'Annuaire',
                        'en' => 'Directory',
                        'de' => 'Verzeichnis',
                    ],
                    'introduction' => [
                        'fr' => '',
                        'en' => '',
                        'de' => '',
                    ],
                    'link' => [
                        'fr' => '',
                        'en' => '',
                        'de' => '',
                    ],
                    'route_name' => [
                        'fr' => 'StoneDirectory',
                        'en' => 'StoneDirectory',
                        'de' => 'StoneDirectory',
                    ],
                    'weight' => [
                        'fr' => 5,
                        'en' => 5,
                        'de' => 5,
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Événements',
                        'en' => 'Events',
                        'de' => 'Ereignis',
                    ],
                    'introduction' => [
                        'fr' => '',
                        'en' => '',
                        'de' => '',
                    ],
                    'link' => [
                        'fr' => '',
                        'en' => '',
                        'de' => '',
                    ],
                    'route_name' => [
                        'fr' => 'StoneEventsListing',
                        'en' => 'StoneEventsListing',
                        'de' => 'StoneEventsListing',
                    ],
                    'weight' => [
                        'fr' => 2,
                        'en' => 2,
                        'de' => 2,
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Actus',
                        'en' => 'News',
                        'de' => 'Aktualität',
                    ],
                    'introduction' => [
                        'fr' => '',
                        'en' => '',
                        'de' => '',
                    ],
                    'link' => [
                        'fr' => '',
                        'en' => '',
                        'de' => '',
                    ],
                    'route_name' => [
                        'fr' => 'StoneNewsListing',
                        'en' => 'StoneNewsListing',
                        'de' => 'StoneNewsListing',
                    ],
                    'weight' => [
                        'fr' => 1,
                        'en' => 1,
                        'de' => 1,
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Bibliothèque',
                        'en' => 'Library',
                        'de' => 'Library',
                    ],
                    'introduction' => [
                        'fr' => 'Retrouvez tous les documents, photos, fiches pratiques ...',
                        'en' => '',
                        'de' => '',
                    ],
                    'link' => [
                        'fr' => '',
                        'en' => '',
                        'de' => '',
                    ],
                    'route_name' => [
                        'fr' => 'StoneGED',
                        'en' => 'StoneGED',
                        'de' => 'StoneGED',
                    ],
                    'weight' => [
                        'fr' => 3,
                        'en' => 3,
                        'de' => 3,
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Outils',
                        'en' => 'Tools',
                        'de' => 'Werkzeug',
                    ],
                    'introduction' => [
                        'fr' => '',
                        'en' => '',
                        'de' => '',
                    ],
                    'link' => [
                        'fr' => '',
                        'en' => '',
                        'de' => '',
                    ],
                    'route_name' => [
                        'fr' => 'StoneToolsListing',
                        'en' => 'StoneToolsListing',
                        'de' => 'StoneToolsListing',
                    ],
                    'weight' => [
                        'fr' => 4,
                        'en' => 4,
                        'de' => 4,
                    ],
                ],
            ],
            'stone_footer_menu_links' => [
                [
                    'title' => [
                        'fr' => 'Contact',
                        'en' => 'Contact',
                        'de' => 'Kontact',
                    ],
                    'icon' => [
                        'fr' => '{"name":"email"}',
                        'en' => '{"name":"email"}',
                        'de' => '{"name":"email"}',
                    ],
                    'link' => [
                        'fr' => 'https://www.google.fr/',
                        'en' => 'https://www.google.fr/',
                        'de' => 'https://www.google.fr/',
                    ],
                    'weight' => [
                        'fr' => 3,
                        'en' => 3,
                        'de' => 3,
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Site',
                        'en' => 'Website',
                        'de' => 'Site',
                    ],
                    'icon' => [
                        'fr' => '{"name":"globe"}',
                        'en' => '{"name":"globe"}',
                        'de' => '{"name":"globe"}',
                    ],
                    'link' => [
                        'fr' => 'https://www.google.fr/',
                        'en' => 'https://www.google.fr/',
                        'de' => 'https://www.google.fr/',
                    ],
                    'weight' => [
                        'fr' => 2,
                        'en' => 2,
                        'de' => 2,
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'LinkedIn',
                        'en' => 'LinkedIn',
                        'de' => 'LinkedIn',
                    ],
                    'icon' => [
                        'fr' => '{"name":"linkedin"}',
                        'en' => '{"name":"linkedin"}',
                        'de' => '{"name":"linkedin"}',
                    ],
                    'link' => [
                        'fr' => 'https://www.google.fr/',
                        'en' => 'https://www.google.fr/',
                        'de' => 'https://www.google.fr/',
                    ],
                    'weight' => [
                        'fr' => 1,
                        'en' => 1,
                        'de' => 1,
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Facebook',
                        'en' => 'Facebook',
                        'de' => 'Facebook',
                    ],
                    'icon' => [
                        'fr' => '{"name":"facebook"}',
                        'en' => '{"name":"facebook"}',
                        'de' => '{"name":"facebook"}',
                    ],
                    'link' => [
                        'fr' => 'https://www.google.fr/',
                        'en' => 'https://www.google.fr/',
                        'de' => 'https://www.google.fr/',
                    ],
                    'weight' => [
                        'fr' => 0,
                        'en' => 0,
                        'de' => 0,
                    ],
                ],
            ],
            'custom' => [
                [
                    'title' => [
                        'fr' => 'Bibliothèque',
                        'en' => 'Library',
                        'de' => 'Bibliothek',
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Communautés',
                        'en' => 'Communities',
                        'de' => 'Gemeinschaft',
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Actualités',
                        'en' => 'News',
                        'de' => 'Aktualitat',
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Espace RH',
                        'en' => 'HR Space',
                        'de' => '',
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Bibliothèque de l\'espace manager',
                        'en' => 'Space manager library',
                        'de' => '',
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Activités',
                        'en' => 'Activities',
                        'de' => 'Aktivitäten',
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Événements managers',
                        'en' => 'Managers events',
                        'de' => '',
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Arrivées et évolutions',
                        'en' => 'Nominations',
                        'de' => 'Termine',
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Le Groupe de A à Z',
                        'en' => 'The Group from A to Z',
                        'de' => 'Die Gruppe von A bis Z',
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Outils et liens utiles Primonial',
                        'en' => 'Tools',
                        'de' => 'Tools',
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Événements du groupe',
                        'en' => 'Events',
                        'de' => 'Ereignis',
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Annuaire des collaborateurs',
                        'en' => 'Directory',
                        'de' => 'Telefonbuch',
                    ],
                ],
                [
                    'title' => [
                        'fr' => 'Nos implantations',
                        'en' => 'Neighborhood map',
                        'de' => 'Unsere Standorte',
                    ],
                ],
            ],
        ];

        $bridge = new BridgeContent();

        $langcodes = ['fr', 'en', 'de'];

        foreach ($contentMapping as $contentType => $contents) {
            foreach ($contents as $content => $fields) {
                foreach ($langcodes as $langcode) {
                    $existing = call_user_func(type_to_class($contentType) . '::query')->where('title', $fields['title']['fr'])->first();

                    if ($contentType === 'custom') {
                        if (!$existing) {
                            continue;
                        }

                        if (empty($fields['title'][$langcode])) {
                            continue;
                        }
                    }

                    $data = [
                        'type' => 'node',
                        'bundle' => $contentType,
                        'langcode' => $langcode,
                    ];

                    if ($existing) {
                        $data['uuid_host'] = $existing->uuid_host;
                    }

                    foreach ($fields as $field => $translations) {
                        $data[$field] = $translations[$langcode];
                    }

                    $bridge->contentInsert($contentType, $data);
                }
            }
        }
    }

    public function down(): void
    {
    }
}
