<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ChangeStoneImageFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'stone_footer_menu_links', 'image');

        $bridge->contentTypeCreateOrUpdateField('stone_footer_menu_links', 'icon', [
            'name' => 'icon',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Icone',
                'en' => 'Icon'
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'weight' => 0,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('custom', 'image', [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ]);
    }
}
