<?php


use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Symfony\Component\Console\Output\ConsoleOutput;

class ReworkLinkFields extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__, 'rework_link_fields');
        $console = new ConsoleOutput();

        $contentTypes = ['links_spaces', 'manager_spaces_tools', 'tools', 'pages'];

        foreach ($contentTypes as $contentType) {
            // Add a new field to save current value
            $linkFieldOptions = Schema::getFieldOptions($contentType, 'link');
            $this->getBridge()->contentTypeCreateOrUpdateField(
                $contentType,
                'ipri_link',
                [
                    'type'                => BridgeContentType::TEXT_FIELD,
                    'name'                => 'ipri_link',
                    'searchable'          => $linkFieldOptions['searchable'] ?? false,
                    'translatable'        => $linkFieldOptions['translatable'] ?? false,
                    'search_result_field' => $linkFieldOptions['search_result_field'] ?? false,
                    'required'            => $linkFieldOptions['required'] ?? false,
                    'weight'              => $linkFieldOptions['weight'] ?? 0,
                    'title'               => $linkFieldOptions['title'] ?? ['fr' => 'Lien'],
                    'description'         => $linkFieldOptions['description'] ?? ['fr' => ''],
                    'widget'              => [
                        'type'     => BridgeContentType::INSIDE_LINK_WIDGET,
                        'settings' => [],
                    ],
                ],
                $linkFieldOptions['weight'] ?? null
            );
        }

        $bridge = new BridgeContent();

        foreach ($contentTypes as $contentType) {
            $contents = call_user_func(type_to_class($contentType) . '::all');

            foreach ($contents as $content) {
                $console->writeln(sprintf('moving link to ipri_link on content %s of type %s', $content->title, $contentType));
                $bridge->contentUpdate($contentType, [
                    'uuid_host' => $content->uuid_host,
                    'langcode' => $content->langcode,
                    'ipri_link' => $content->link
                ]);
            }
        }

        foreach ($contentTypes as $contentType) {
            $this->getBridge()->contentTypeDeleteField('node', $contentType, 'link');
        }

        foreach ($contentTypes as $contentType) {
            // Add a new field to save current value
            $linkFieldOptions = Schema::getFieldOptions($contentType, 'ipri_link');
            $this->getBridge()->contentTypeCreateOrUpdateField(
                $contentType,
                'link',
                [
                    'type'                => BridgeContentType::TEXT_FIELD,
                    'name'                => 'link',
                    'searchable'          => $linkFieldOptions['searchable'] ?? false,
                    'translatable'        => $linkFieldOptions['translatable'] ?? false,
                    'search_result_field' => $linkFieldOptions['search_result_field'] ?? false,
                    'required'            => $linkFieldOptions['required'] ?? false,
                    'weight'              => $linkFieldOptions['weight'] ?? 0,
                    'title'               => $linkFieldOptions['title'] ?? ['fr' => 'Lien'],
                    'description'         => $linkFieldOptions['description'] ?? ['fr' => ''],
                    'widget'              => [
                        'type'     => BridgeContentType::INSIDE_LINK_WIDGET,
                        'settings' => [],
                    ],
                ],
                $linkFieldOptions['weight'] ?? null
            );
        }

        foreach ($contentTypes as $contentType) {
            $contents = call_user_func(type_to_class($contentType) . '::all');

            foreach ($contents as $content) {
                $console->writeln(sprintf('moving ipri_link to link on content %s of type %s', $content->title, $contentType));
                $bridge->contentUpdate($contentType, [
                    'uuid_host' => $content->uuid_host,
                    'langcode' => $content->langcode,
                    'link' => $content->ipri_link
                ]);
            }
        }

        foreach ($contentTypes as $contentType) {
            $this->getBridge()->contentTypeDeleteField('node', $contentType, 'ipri_link');
        }
    }

    public function down(): void
    {
    }
}
