<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Database\Migrations\HasConsole;
use Inside\Notify\Models\NotificationType;

class addMovementOnCommentNotificationType extends Migration
{
    use HasConsole;

    public function up(): void
    {
        $this->write(
            'Recherche de la notification de <fg=magenta>Commentaires</fg=magenta>'
        );

        /**
         * @var ?NotificationType $notificationType
         */
        $notificationType = NotificationType::where(
            [
                'via'    => 'web',
                'event'  => \Inside\Content\Events\CommentCreatedEvent::class,
                'model'  => \Inside\Content\Models\Contents\Comments::class,
                'action' => 'contentCommented',
            ]
        )->first();
        if ($notificationType === null) {
            $this->writeResult(false);

            return;
        }
        $this->write(' (<fg=cyan>' . $notificationType->id . '</fg=cyan>)');
        $this->writeResult(true);
        // Notification de report
        $this->write(
            'Modification notification de <fg=magenta>Commentaires</fg=magenta>'
        );
        $this->writeResult(
            $notificationType->update(
                [
                    'condition' => 'parent_type:news,events,manager_spaces_events,movements',
                ]
            )
        );
    }
}
