<?php


use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixIntroductionFields extends Migration
{
    public function up(): void
    {
        $contents = [];

        $groups = \Inside\Content\Models\Contents\Groups::all();

        foreach ($groups as $group) {
            $contents[$group->uuid] = $group->introduction;
        }


        $bridgeContentType = new \Inside\Host\Bridge\BridgeContentType();

        $bridgeContentType->contentTypeDeleteField('node', 'groups', 'introduction');

        $bridgeContentType->contentTypeCreateOrUpdateField('groups', 'introduction', [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'introduction',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
            ],
            'description'         => [
                'fr' => 'Texte d\'introduction du groupe',
                'en' => 'Group\'s introduction',
            ],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
            ],
        ]);

        $bridge = new \Inside\Host\Bridge\BridgeContent();

        foreach ($contents as $uuid => $value) {
            $bridge->contentUpdate('groups', [
                'type' => 'node',
                'bundle' => 'groups',
                'uuid' => $uuid,
                'introduction' => $value,
            ]);
        }

        $bridgeContentType->contentTypeCreateOrUpdateField('forms', 'introduction', [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'introduction',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 1,
            'default'             => null,
            'title'               => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight'   => -1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
