<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddNewsCategoriesToForms extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new \Inside\Host\Bridge\BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField('forms', 'news_categories', [
            'name' => 'news_categories',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'title' => [
                'fr' => 'Categories d\'actualités',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => ['news_categories'],
                'cardinality' => -1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
