<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class CallNewsNotificationsSeeder extends Migration
{
    public function up(): void
    {
        $notificationType = NotificationType::query()->where('via', 'email')->where('model', 'Inside\Content\Models\Contents\News')->where('condition', 'is_featured:1|status:1')->first();

        if (!$notificationType instanceof NotificationType) {
            Artisan::call('db:seed', ['--class' => 'NewsFeaturedMailNotificationSeeder']);

            /** @var NotificationType $notificationType */
            $notificationType = NotificationType::query()->where('via', 'email')->where('model', 'Inside\Content\Models\Contents\News')->where('condition', 'is_featured:1|status:1')->first();
        }

        $notificationType->default = 1;
        $notificationType->action = 'create';
        $notificationType->data = [
            'title'       => 'notifications.create.news.featured.mail.title',
            'description' => 'notifications.create.news.featured.mail.description',
            'mail'        => [
                'subject'    => 'notifications.create.news.featured.mail.subject',
                'text'       => 'notifications.create.news.featured.mail.content',
                'buttonText' => 'notifications.create.news.featured.mail.buttonText'
            ],
            'fields' => [
                'title',
                'authors' => ['firstname', 'lastname'],
            ]
        ];
        $notificationType->save();

        Users::all()->each(function ($user) use ($notificationType) {
            NotificationSubscriber::firstOrCreate([
                'user_uuid'            => $user->uuid,
                'notification_type_id' => $notificationType->id,
            ]);
        });
    }

    public function down(): void
    {
    }
}
