<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddWeightFieldOnNews extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new \Inside\Host\Bridge\BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField('news', 'weight', [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'default' => 0,
            'search_result_field' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Poids',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 8,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
