<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddEndDateFieldOnManagerSpacesEvents extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new \Inside\Host\Bridge\BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField('manager_spaces_events', 'end_date', [
            'name' => 'end_date',
            'searchable' => false,
            'translatable' => true,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Date de fin',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
