<?php

use Illuminate\Support\Facades\Log;

return [
    'schedule' => [
        'log_status' => function ($scheduler) {
            $scheduler->call(function () {
                Log::info('Scheduler is running.');
            })->hourly();
        },
        'tools_export' => function ($scheduler) {
            $scheduler->command('ipri:export-tools')->daily()->at('2:00');
        },
        'userimport' => function ($scheduler) {
            $scheduler->command('inside:user:import azuread --disable-not-imported')->daily()->at('05:30')->timezone('Europe/Paris');
        }
    ],
];
