<?php

$entities = collect(config('entities', explode(',', env('APP_ENTITIES_LIST'))));

return [
    'discovering_attribute' => 'id',
    'postfilter' => static fn ($users) => $users->reject(
        fn ($user) => !$entities->contains(str($user->companyName ?? '')->trim()->lower()->toString())
    ),
    'sync_attributes' => [
        'name' => 'userPrincipalName',
        'mail' => 'userPrincipalName',
        'function' => 'jobTitle',
        'firstname' => 'givenName',
        'lastname' => 'surname',
        'phone' => fn ($user) => implode(", ", $user->businessPhones),
        'mobile_phone' => 'mobilePhone',
        'fullname' => 'displayName',
        'entities' => fn ($user) => reference('entities')
            ->from($user->companyName)
            ->get(),
        'locations' => fn ($user) => reference('locations')
            ->from($user->state)
            ->get(),
        'users' => fn ($user) => reference('users')
            ->identifiedBy('fullname')
            ->usingLikeOperator()
            ->from($user->manager)
            ->withoutCreation()
            ->first(),
        'langcode' => fn () => 'fr',
        'is_manager' => fn ($user) => isset($user->directReports) && !empty($user->directReports),
        'is_maintenance' => fn ($user) => empty($user->surname),
        'is_stone_user' =>  false,
    ],
    'custom_attributes' => [
        'manager' => 'displayName',
        'directReports' => 'value',
    ]
];
