<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class SetupIpriQuickAccess extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        $orderedTools = [
            'Artemis' => 0,
            'Galexy' => 1,
            'Le Cloud' => 2
        ];

        $tools = Tools::query()
            ->whereIn('title', array_keys($orderedTools))
            ->where('status', 1)
            ->where('langcode', 'fr')
            ->get()
            ->sortBy(fn (Tools $tool) => $orderedTools[$tool->title]);


        // Update tools orders
        $tools->each(
            fn (Tools $tool) => $bridgeContent->contentUpdate(
                type: 'tools',
                data: [
                    'uuid' => $tool->uuid,
                    'title' => $tool->title,
                    'weight' => $orderedTools[$tool->title]
                ]
            )
        );

        $bridge->contentTypeCreateOrUpdateField('users', 'tools', [
            'title' => ['fr' => 'Outils'],
            'default' => $tools
                ->map(fn (Tools $tool) => ['target_uuid' => $tool->uuid_host])
                ->toArray(),
        ]);
    }
}
