<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema as InsideSchema;

class RemoveSignUpFieldToEvents extends Migration
{
    public function up(): void
    {
        if (! InsideSchema::hasField(modelName: 'events', fieldName: 'sign_up')) {
            return;
        }

        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField(
            'node',
            'events',
            'sign_up',
        );
        Artisan::call('models:rebuild');
    }
}
